/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rsf.managereqs;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class RsfRequestInfo
implements Serializable {
    private static final LocalizableText HANDLING = new LocalizableText(BaseTextBundle.getBundleName(), "rsf.state.handling");
    private static final LocalizableText CANCELING = new LocalizableText(BaseTextBundle.getBundleName(), "rsf.state.canceling");
    private static final LocalizableText REPORTING = new LocalizableText(BaseTextBundle.getBundleName(), "rsf.state.reporting");
    private String callHomeServer;
    private Date date;
    private LocalizableText description;
    private String id;
    private int state;

    public RsfRequestInfo(String id, int state, String callHomeServer, Date date, LocalizableText description) {
        this.id = id;
        this.state = state;
        this.callHomeServer = callHomeServer;
        this.date = date;
        this.description = description;
    }

    public RsfRequestInfo(String id, Date date, LocalizableText description) {
        this(id, -1, null, date, description);
    }

    public RsfRequestInfo(RsfRequest request) {
        this(request.getId(), request.getState(), request.getCallHomeServerName(), request.getSubmitDate(), request.getDescription());
    }

    public RsfRequestInfo() {
        this(null, -1, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getState() {
        switch (this.state) {
            case 2: {
                return HANDLING.toString();
            }
            case 3: {
                return CANCELING.toString();
            }
            case 4: {
                return REPORTING.toString();
            }
        }
        return "";
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getCallHomeServer() {
        return this.callHomeServer;
    }

    public void setCallHomeServer(String callHomeServer) {
        this.callHomeServer = callHomeServer;
    }

    public Calendar getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        return calendar;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public LocalizableText getDescription() {
        return this.description;
    }

    public void setDescription(LocalizableText description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RsfRequestInfo)) {
            return false;
        }
        RsfRequestInfo reqInfo = (RsfRequestInfo)obj;
        return this.id.equals(reqInfo.id) && this.description.equals(reqInfo.description);
    }

    public int hashCode() {
        return this.id.hashCode() + this.description.hashCode();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("RsfRequestInfo[ ");
        str.append("id=" + this.getId() + " , ");
        str.append("state=" + this.getState() + " , ");
        str.append("server=" + this.getCallHomeServer() + " , ");
        str.append("date=" + this.getDate().toString() + " , ");
        str.append("desc=" + this.getDescription() + " ]");
        return str.toString();
    }
}

